function updateResult() {
            const divisionName = document.getElementById('division').selectedOptions[0]?.text || '';
            const districtName = document.getElementById('district').selectedOptions[0]?.text || '';
            const upzilaName = document.getElementById('upzila').selectedOptions[0]?.text || '';
            const unionName = document.getElementById('union').selectedOptions[0]?.text || '';

            document.getElementById('result').textContent = `Selected Names: ${divisionName} ${districtName} ${upzilaName} ${unionName}`;
        }

        async function loadDivisions() {
            try {
                const response = await fetch(`https://sohojapi.vercel.app/api/divisions`);
                const divisions = await response.json();
                const divisionSelect = document.getElementById('division');

                divisions.forEach(division => {
                    const option = document.createElement('option');
                    option.value = division.id;
                    option.textContent = division.name;
                    divisionSelect.appendChild(option);
                    /* division.name এটা ইংরেজীতে ডেটা show করবে,আর আপনি যদি চান যে ডেটা বাংলাতে show করবে,তাহলে division.bn_name এটা দিতে হবে*/
                });
            } catch (error) {
                console.error("Error loading divisions:", error);
            }
        }

        document.getElementById('division').addEventListener('change', async (e) => {
            const divisionId = e.target.value;
            const districtSelect = document.getElementById('district');
            districtSelect.innerHTML = '<option value="">-- Select District --</option>';
            document.getElementById('upzila').innerHTML = '<option value="">-- Select Upzila --</option>';
            document.getElementById('union').innerHTML = '<option value="">-- Select Union --</option>';
            document.getElementById('upzila').disabled = true;
            document.getElementById('union').disabled = true;
            updateResult();

            if (divisionId) {
                try {
                    const response = await fetch(`https://sohojapi.vercel.app/api/districts/${divisionId}`);
                    const districts = await response.json();

                    districts.forEach(district => {
                        const option = document.createElement('option');
                        option.value = district.id;
                        option.textContent = district.name;
                        districtSelect.appendChild(option);
                    });
                                        /* district.name এটা ইংরেজীতে ডেটা show করবে,আর আপনি যদি চান যে ডেটা বাংলাতে show করবে,তাহলে district.bn_name এটা দিতে হবে*/
                    districtSelect.disabled = false;
                } catch (error) {
                    console.error("Error loading districts:", error);
                }
            }
        });

        document.getElementById('district').addEventListener('change', async (e) => {
            const districtId = e.target.value;
            const upzilaSelect = document.getElementById('upzila');
            upzilaSelect.innerHTML = '<option value="">-- Select Upzila --</option>';
            document.getElementById('union').innerHTML = '<option value="">-- Select Union --</option>';
            document.getElementById('union').disabled = true;
            updateResult();

            if (districtId) {
                try {
                    const response = await fetch(`https://sohojapi.vercel.app/api/upzilas/${districtId}`);
                    const upzilas = await response.json();

                    upzilas.forEach(upzila => {
                        const option = document.createElement('option');
                        option.value = upzila.id;
                        option.textContent = upzila.name;
                        upzilaSelect.appendChild(option);
                    });
                    upzilaSelect.disabled = false;
                                        /* upzila.name এটা ইংরেজীতে ডেটা show করবে,আর আপনি যদি চান যে ডেটা বাংলাতে show করবে,তাহলে upzila.bn_name এটা দিতে হবে*/
                } catch (error) {
                    console.error("Error loading upzilas:", error);
                }
            }
        });

        document.getElementById('upzila').addEventListener('change', async (e) => {
            const upzilaId = e.target.value;
            const unionSelect = document.getElementById('union');
            unionSelect.innerHTML = '<option value="">-- Select Union --</option>';
            updateResult();

            if (upzilaId) {
                try {
                    const response = await fetch(`https://sohojapi.vercel.app/api/unions/${upzilaId}`);
                    const unions = await response.json();

                    unions.forEach(union => {
                        const option = document.createElement('option');
                        option.value = union.id;
                        option.textContent = union.name;
                        unionSelect.appendChild(option);
                    });
                    unionSelect.disabled = false;
                                        /* union.name এটা ইংরেজীতে ডেটা show করবে,আর আপনি যদি চান যে ডেটা বাংলাতে show করবে,তাহলে union.bn_name এটা দিতে হবে*/
                } catch (error) {
                    console.error("Error loading unions:", error);
                }
            }
        });

        document.getElementById('union').addEventListener('change', updateResult);
        loadDivisions();